local Image = require("widgets/image")
local Text = require("widgets/text")
local Widget = require("widgets/widget")

---
-- Displays a badge with a number, indicating an item's level
--

local ItemLevelBadge = Class(Widget, function(self, size)
	Widget._ctor(self, "ItemLevelBadge")

	self.size = size

	self.background = self:AddChild(Image("images/ui_ftf_shop/item_level_badge.tex"))
		:SetName("Background")

	self.level = self:AddChild(Text(FONTFACE.DEFAULT, 60, "", UICOLORS.BLACK))
		:SetShadowColor(HexToRGB(0x20C4E7ff))
		:SetShadowOffset(0, -5)
		:EnableShadow()

	self:SetSize(self.size)
end)

function ItemLevelBadge:SetItem(item, item_level)
	if item_level then
		self.level:SetText(item_level)
	else
		self.level:SetText(item and item:GetBaseItemLevel())
	end
	self:Layout()
    return self
end

function ItemLevelBadge:SetSize(size)
	self.size = size or 100
	self.background:SetSize(self.size, self.size)
	self.level:SetFontSize(self.size*0.65)
		:SetShadowOffset(0, -self.size * 0.04)
	self:Layout()
	return self
end

function ItemLevelBadge:Layout()
	self.level
		:LayoutBounds("center", "center", self.background)
		:Offset(0, self.size * 0.025)
	return self
end

return ItemLevelBadge
